(function() {
    var perPage = 10;
    var currentPage = 1;
    var currentFilter = 'all';
    var searchTerm = '';

    function getFilteredRows() {
        var rows = document.querySelectorAll('#modules-table .module-row');
        var filtered = [];
        for (var i = 0; i < rows.length; i++) {
            var row = rows[i];
            var matchesSearch = true;
            if (searchTerm) {
                var name = (row.getAttribute('data-name') || '').toLowerCase();
                var desc = (row.getAttribute('data-description') || '').toLowerCase();
                var slug = (row.getAttribute('data-slug') || '').toLowerCase();
                matchesSearch = name.indexOf(searchTerm) !== -1 ||
                               desc.indexOf(searchTerm) !== -1 ||
                               slug.indexOf(searchTerm) !== -1;
            }
            var matchesFilter = true;
            if (currentFilter === 'free') {
                matchesFilter = row.getAttribute('data-free') === '1';
            } else if (currentFilter === 'paid') {
                matchesFilter = row.getAttribute('data-free') === '0';
            } else if (currentFilter === 'installed') {
                matchesFilter = row.getAttribute('data-installed') === '1';
            } else if (currentFilter === 'not-installed') {
                matchesFilter = row.getAttribute('data-installed') === '0';
            }
            if (matchesSearch && matchesFilter) {
                filtered.push(row);
            }
        }
        return filtered;
    }

    function render() {
        var rows = document.querySelectorAll('#modules-table .module-row');
        var filtered = getFilteredRows();

        // Hide all rows
        for (var i = 0; i < rows.length; i++) {
            rows[i].style.display = 'none';
        }

        var totalPages = Math.ceil(filtered.length / perPage);
        if (currentPage > totalPages) currentPage = totalPages;
        if (currentPage < 1) currentPage = 1;

        var start = (currentPage - 1) * perPage;
        var end = start + perPage;

        // Show filtered rows for current page
        for (var i = start; i < end && i < filtered.length; i++) {
            filtered[i].style.display = '';
        }

        // Update count
        var countEl = document.getElementById('modules-count');
        if (countEl) countEl.textContent = filtered.length;

        // Show/hide no results
        var noResults = document.getElementById('no-results');
        var table = document.getElementById('modules-table');
        if (noResults && table) {
            noResults.style.display = filtered.length === 0 ? 'block' : 'none';
            table.style.display = filtered.length === 0 ? 'none' : '';
        }

        renderPagination(totalPages);
    }

    function renderPagination(totalPages) {
        var pagination = document.getElementById('pagination');
        if (!pagination) return;
        pagination.innerHTML = '';
        if (totalPages <= 1) return;

        // Previous button
        var prevLi = document.createElement('li');
        if (currentPage === 1) prevLi.className = 'disabled';
        var prevA = document.createElement('a');
        prevA.href = '#';
        prevA.innerHTML = '&laquo;';
        prevA.addEventListener('click', function(e) {
            e.preventDefault();
            if (currentPage > 1) {
                currentPage--;
                render();
            }
        });
        prevLi.appendChild(prevA);
        pagination.appendChild(prevLi);

        // Page numbers
        for (var i = 1; i <= totalPages; i++) {
            (function(page) {
                var li = document.createElement('li');
                if (page === currentPage) li.className = 'active';
                var a = document.createElement('a');
                a.href = '#';
                a.textContent = page;
                a.addEventListener('click', function(e) {
                    e.preventDefault();
                    currentPage = page;
                    render();
                });
                li.appendChild(a);
                pagination.appendChild(li);
            })(i);
        }

        // Next button
        var nextLi = document.createElement('li');
        if (currentPage === totalPages) nextLi.className = 'disabled';
        var nextA = document.createElement('a');
        nextA.href = '#';
        nextA.innerHTML = '&raquo;';
        nextA.addEventListener('click', function(e) {
            e.preventDefault();
            if (currentPage < totalPages) {
                currentPage++;
                render();
            }
        });
        nextLi.appendChild(nextA);
        pagination.appendChild(nextLi);
    }

    function init() {
        // Check if table exists
        var table = document.getElementById('modules-table');
        if (!table) return;

        // Get perPage from data attribute if set
        var perPageAttr = table.getAttribute('data-per-page');
        if (perPageAttr) perPage = parseInt(perPageAttr, 10) || 10;

        // Search input
        var searchInput = document.getElementById('modules-search');
        if (searchInput) {
            searchInput.addEventListener('input', function() {
                searchTerm = this.value.toLowerCase();
                currentPage = 1;
                render();
            });
            searchInput.addEventListener('keyup', function() {
                searchTerm = this.value.toLowerCase();
                currentPage = 1;
                render();
            });
        }

        // Clear search button
        var clearBtn = document.getElementById('modules-search-clear');
        if (clearBtn) {
            clearBtn.addEventListener('click', function() {
                if (searchInput) searchInput.value = '';
                searchTerm = '';
                currentPage = 1;
                render();
            });
        }

        // Filter buttons
        var filterBtns = document.querySelectorAll('[data-filter]');
        for (var i = 0; i < filterBtns.length; i++) {
            (function(btn) {
                btn.addEventListener('click', function(e) {
                    e.preventDefault();
                    for (var j = 0; j < filterBtns.length; j++) {
                        filterBtns[j].classList.remove('active');
                    }
                    this.classList.add('active');
                    currentFilter = this.getAttribute('data-filter');
                    currentPage = 1;
                    render();
                });
            })(filterBtns[i]);
        }

        // Initial render
        render();
    }

    // Initialize when DOM is ready
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', init);
    } else {
        init();
    }
})();
