<?php

namespace Modules\FreescoutInstaller\Providers;

use Illuminate\Support\ServiceProvider;
use Modules\FreescoutInstaller\Services\CatalogService;

class FreescoutInstallerServiceProvider extends ServiceProvider
{
    public function register()
    {
        $this->registerConfig();
        $this->registerViews();
    }

    public function boot()
    {
        if (!defined('FREESCOUT_INSTALLER_MODULE')) {
            define('FREESCOUT_INSTALLER_MODULE', 'freescoutinstaller');
        }

        $this->registerRoutes();
        $this->registerSettingsSection();
        $this->registerViewComposers();
        $this->registerAssets();
    }

    protected function registerAssets()
    {
        // Assets are served via route - see routes.php
    }

    protected function registerConfig()
    {
        $this->mergeConfigFrom(__DIR__ . '/../Config/config.php', 'freescoutinstaller');
    }

    protected function registerViews()
    {
        $this->loadViewsFrom(array_merge(array_map(function ($path) {
            return $path . '/modules/freescoutinstaller';
        }, \Config::get('view.paths')), [__DIR__ . '/../Resources/views']), 'freescoutinstaller');
    }

    protected function registerRoutes()
    {
        $this->loadRoutesFrom(__DIR__ . '/../Http/routes.php');
    }

    protected function registerSettingsSection()
    {
        \Eventy::addFilter('settings.sections', function ($sections) {
            $sections['freescoutinstaller'] = [
                'title' => __('Freescout Installer'),
                'icon' => 'download',
                'view' => 'freescoutinstaller::settings',
                'order' => 200,
            ];

            return $sections;
        });

        \Eventy::addFilter('settings.section_params', function ($params, $section) {
            if ($section !== 'freescoutinstaller') {
                return $params;
            }

            $catalog = CatalogService::fetch();

            $params['title'] = __('Freescout Installer');
            $params['view'] = 'freescoutinstaller::settings';
            $params['settings'] = $params['settings'] ?? [];

            return $params;
        }, 20, 2);

        \Eventy::addFilter('settings.section_settings', function ($settings, $section) {
            if ($section !== 'freescoutinstaller') {
                return $settings;
            }

            // Ensure settings are not empty so the core controller does not abort.
            $settings['freescoutinstaller.enabled'] = \Option::get('freescoutinstaller.enabled', true);

            return $settings;
        }, 20, 2);

        \Eventy::addFilter('settings.view', function ($view, $section) {
            if ($section !== 'freescoutinstaller') {
                return $view;
            }

            return 'freescoutinstaller::settings.index';
        }, 20, 2);
    }

    protected function registerViewComposers()
    {
        \View::composer('freescoutinstaller::settings.index', function ($view) {
            $catalog = CatalogService::fetch();
            $view->with('modules', $catalog['modules'] ?? []);
            $view->with('error', $catalog['error'] ?? null);
            $view->with('installedAliases', CatalogService::getInstalledAliases());
            $view->with('enabledAliases', CatalogService::getEnabledAliases());
        });
    }
}
