<?php

Route::group([
    'middleware' => ['web', 'auth'],
    'prefix' => \Helper::getSubdirectory(),
    'namespace' => 'Modules\\FreescoutInstaller\\Http\\Controllers'
], function () {
    Route::get('/app-settings/freescoutinstaller', [
        'uses' => 'FreescoutInstallerController@settings',
        'laroute' => true,
    ])->name('freescoutinstaller_settings');

    Route::post('/settings/freescout-installer/install', [
        'uses' => 'FreescoutInstallerController@install',
    ])->name('freescoutinstaller_install');

    Route::get('/modules/freescoutinstaller/js/installer.js', function () {
        $path = base_path('Modules/FreescoutInstaller/Public/js/installer.js');
        if (!file_exists($path)) {
            abort(404);
        }
        return response(file_get_contents($path), 200)
            ->header('Content-Type', 'application/javascript');
    })->name('freescoutinstaller_js');
});
